/***************************************************************************/
/**                                                                       **/
/**                               MAGICARD                                **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : SDK C# Demo - DTC Printers                            **/
/**                                                                       **/
/**  MODULE NAME  : Utils.cs                                               **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard                                              **/
/**                                                                       **/
/***************************************************************************/
using System;
using System.Text;
using System.Windows.Forms;
using System.Collections.Generic;
using SDKShim;

namespace CSharpDemo
{
    public partial class SDK_CSDemo : Form
    {
        #region === Local Methods ===

        private void InitUtilsTab()
        {
            
        }

        private void ClearUtilsMsgBoxButton_Click(object sender, EventArgs e)
        {
            UtilsMsgBox.Clear();
        }

        #endregion === Local Methods ===

        //----------------------------------------------------------------------

        #region === Single Line Encoding ===

        private void SendAPDUButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            string tempString = "";

            if (SendAPDUBox.Text.Length == 0)
            {
                MessageBox.Show("APDU Box is empty");
            }
            else
            {
                List<string> APDUList = new List<string>(
                           SendAPDUBox.Text.Split(new string[] { "\r\n", "\n" }, 
                           StringSplitOptions.RemoveEmptyEntries));

                foreach (string APDU in APDUList)
                {

                    UtilsMsgBox.AppendText("APDU Sent -> " + APDU + Environment.NewLine);
                    UtilsMsgBox.AppendText(Environment.NewLine);

                    StringBuilder APDUReturn = new StringBuilder();
                    StringBuilder APDUInput = new StringBuilder(APDU, 512);

                    SDK.Return SDKReturn = SDK.ID_SendAPDU(hSession, APDUInput, APDUReturn);
                    if (SDKReturn != SDK.Return.Success)
                    {
                        HandleError("SendAPDU", SDKReturn);
                    }
                    else
                    {

                        tempString = APDUReturn.ToString();

                        UtilsMsgBox.AppendText("APDU Reply: " + APDUReturn.ToString() + Environment.NewLine);
                        UtilsMsgBox.AppendText(Environment.NewLine);
                    }

                }

                
            }
            Cursor.Current = Cursors.Default;
        }

        #endregion === Single Line Encoding ===

        //----------------------------------------------------------------------

    }
}
